" Vim syntax file
" Language: Wiki MoinMoin style (see http://moin.sf.net/)

"What to do to install this file:
" $ mkdir -p ~/.vim/syntax
" $ cp wiki-moin.vim ~/.vim/syntax
" and optionally (you can set the filetype manually without it!)
" $ cat >>~/.vim/filetype.vim <<EOF
" augroup filetypedetect
" au BufNewFile,BufRead *.wiki-moin setf wiki-moin
" augroup END
" EOF
"
"If you do not already have a .vimrc with syntax on then do this:
" $ echo "syntax on" >>~/.vimrc
"
"Now every file with a filename matching *.wiki-moin will be edited
"using these definitions for syntax highlighting.

" For version 5.x: Clear all syntax items
" For version 6.x: Quit when a syntax file was already loaded
if version < 600
  syntax clear
elseif exists("b:current_syntax")
  finish
endif

syn match wikiName     /[^\!]\(\u[a-z0-9]\+\)\{2,}/ms=s+1
syn match wikiName     /^\w*\u\w*[a-z0-9]\w*\u\w*/
syn match wikiURL      /\(http\|https\|gopher\|mailto\|news\|ftp\|file\):\(\S\+\)/
syn match wikiRule     /^-\{4,}/
syn match wikiBullet   /^\(\s\)\+\*\s/
syn match wikiNumItem  /^\(\s\)\+\d\+[.)]\s/
syn match wikiToDo     /ToDo/
syn match wikiEmail    /\S\+@\S\+\(.\S+\)*/

syn region wikiHead start="^=\{1,4} " end=" =\{1,4}$" oneline
" syn region wikiItem start="^*\{1,4}" end="$" contains=ALL oneline keepend 
syn region wikiPre start="{{{" end="}}}"
syn region wikiPre start="`" end="`" oneline
syn region wikiMacro start="\[\[" end="\]\]" oneline
syn region wikiLink start="\[\"" end="\"\]" oneline
syn region wikiBold start="\'\{3}" end="\'\{3}"
syn region wikiItalic start="\'\{2}[^\']"  end="\'\{2}\([^\']\|$\)"
syn region wikiMeta start="^#" end="$" oneline

" Define the default highlighting.
" For version 5.7 and earlier: only when not done already
" For version 5.8 and later: only when an item doesn't have highlighting yet
if version <= 508 || !exists("did_wiki_syntax_inits")
  if version < 508
    let did_wiki_syntax_inits = 1
    command -nargs=+ HiLink hi link <args>
  else
    command -nargs=+ HiLink hi def link <args>
  endif

  HiLink wikiHead      Function
  HiLink wikiPre       PreProc
  HiLink wikiMacro     Identifier
  HiLink wikiLink      Underlined 
  HiLink wikiName      Underlined
  HiLink wikiURL       PreProc
  HiLink wikiEmail     PreProc
  HiLink wikiBullet    Label
  HiLink wikiRule      Identifier
  HiLink wikiNumItem   Label
  HiLink wikiBold      Type
  HiLink wikiItalic    String
  HiLink wikiMeta      Comment
  HiLink wikiToDo      Todo
      
  delcommand HiLink
endif

let b:current_syntax = "wiki-moin"

