    #----------------------------------------------------------------------------
    # create share(s)for samba fileserver:
    #----------------------------------------------------------------------------

    echo "configuring shares"
    idx='1'

    while [ "$idx" -le "$SAMBA_SHARE_N" ]
    do
          eval name='$SAMBA_SHARE_'$idx'_NAME'
          eval write='$SAMBA_SHARE_'$idx'_RW'
          eval browse='$SAMBA_SHARE_'$idx'_BROWSE'
          eval path='$SAMBA_SHARE_'$idx'_PATH'
          path=$path/$name
          eval hosts='$SAMBA_SHARE_'$idx'_NET'

          if [ ! -d "$path" ]
          then
               mkdir $path
               if [ "$?" = "0" ]
               then 
                    echo "directory $path for share $name on $HOSTNAME created"
               else
                    colecho "*** ERROR: cannot create directory $path for share $name on $HOSTNAME! ***" br x br
                    colecho "*** ERROR: check OPT_MOUNT and SAMBA_SHARE_PATH! ***" br x br
               fi
          else
               echo "directory for share $name on $HOSTNAME always exists"
          fi

          if [ "$hosts" != '' ]    # which net will be allowed to access the share?
          then                     # net is defined
              hosts1=$hosts        # net in SAMBA_SHARE_NET_X will be allowed
              echo "share $name on $HOSTNAME will be accessable for network(s):"
              echo "$hosts1"
          else                     # net is not defined
              hosts1=$sambahosts   # net in IP_ETH_X_NETWORK/$IP_ETH_X_NETMASK will be allowed
              echo "share $name on $HOSTNAME will be accessable for network(s):"
              echo "$hosts1"
          fi

         (echo "[$name]"
          echo "   comment = share $name on $HOSTNAME"
          echo "   browseable = $browse"
          echo "   available = yes"
          echo "   writeable = $write"
          echo "   path = $path"
          echo "   hosts allow = $hosts1"
          echo "   force user = root"
          echo "   "
          ) >> /etc/smb.conf
          idx=`expr $idx + 1`
    done

    #----------------------------------------------------------------------------
    # create share(s) for cdrom(s):
    #----------------------------------------------------------------------------

    idx='1'

    while [ "$idx" -le "$SAMBA_CDROM_N" ]
    do
          eval dev='$SAMBA_CDROM_'$idx'_DEV'
          eval hosts='$SAMBA_CDROM_'$idx'_NET'
          path=''

          if [ "$hosts" != '' ]    # which net will be allowed to access the share?
          then                     # net is defined
              hosts1=$hosts        # net in SAMBA_CDROM_NET_X will be allowed
              echo "cdrom$idx on $HOSTNAME will be accessable for network(s):"
              echo "$hosts1"
          else                     # net is not defined
              hosts1=$sambahosts   # net in IP_ETH_X_NETWORK/$IP_ETH_X_NETMASK will be allowed
              echo "cdrom$idx on $HOSTNAME will be accessable for network(s):"
              echo "$hosts1"
          fi

          if [ -n "`cat /proc/mounts | grep $dev`" ]
          then                     # found mounted cdrom$idx
              echo "cdrom$idx already mounted"
              path=`cat /proc/mounts | grep /dev/$dev | cut -d" " -f2`  # cut mountpath for sharing
              echo "path for cdrom$idx is $path"
              exec=false
          else                     # cdrom$idx not mounted
              echo "cdrom$idx not mounted"
              path=/mnt/cdrom$idx
              echo "path for cdrom$idx is $path"
              exec=true

              if [ ! -d /mnt/cdrom$idx ]
              then
                  mkdir /mnt/cdrom$idx
              fi
          fi

         (echo "[cdrom$idx]"
          echo "   comment = cdrom$idx on $HOSTNAME at device $dev"
          echo "   read only = yes"
          echo "   hosts allow = $hosts1"
          echo "   path = $path"
          ) >> /etc/smb.conf

          if [ "$exec" = "true" ]
          then 
              (echo "   root preexec = /bin/mount -t iso9660 /dev/$dev /mnt/cdrom$idx -o ro"
               echo "   root postexec = /bin/umount /dev/$dev"
               echo "   "
               ) >> /etc/smb.conf
          else
              (echo "   "
               ) >> /etc/smb.conf
          fi
          idx=`expr $idx + 1`
    done