#############################################################
#
# aumix, example makefile for debian sources derived from
# http://buildroot.uclibc.org/buildroot.html#add_software 
#
#############################################################
AUMIX_VERSION:=2.8
AUMIX_SOURCE:=aumix_$(AUMIX_VERSION).orig.tar.gz

AUMIX_PATCH_VERSION:=20
AUMIX_PATCH:=aumix_$(AUMIX_VERSION)-$(AUMIX_PATCH_VERSION).diff.gz

AUMIX_SITE:=http://ftp.de.debian.org/debian/pool/main/a/aumix
AUMIX_DIR:=$(BUILD_DIR)/aumix-$(AUMIX_VERSION)
REAL_AUMIX_DIR:=$(AUMIX_DIR)/aumix-$(AUMIX_VERSION)
AUMIX_BINARY:=aumix
AUMIX_TARGET_BINARY:=usr/bin/aumix

#
# get the tarball
#
$(DL_DIR)/$(AUMIX_SOURCE):
	$(WGET) -P $(DL_DIR) $(AUMIX_SITE)/$(AUMIX_SOURCE) 

#
# get the patches
#
$(DL_DIR)/$(AUMIX_PATCH):
	$(WGET) -P $(DL_DIR) $(AUMIX_SITE)/$(AUMIX_PATCH) 

#
# unpack the tarball
# apply patch and all patches contained in debian/patches
# 
$(AUMIX_DIR)/.unpacked: $(DL_DIR)/$(AUMIX_SOURCE) $(DL_DIR)/$(AUMIX_PATCH)
	zcat $(DL_DIR)/$(AUMIX_SOURCE) | tar -C $(BUILD_DIR) $(TAR_OPTIONS) -
	mv $(AUMIX_DIR).orig $(AUMIX_DIR)
	toolchain/patch-kernel.sh $(AUMIX_DIR) $(DL_DIR) $(AUMIX_PATCH)
	tar -C $(AUMIX_DIR) -xjf $(AUMIX_DIR)/aumix-$(AUMIX_VERSION).tar.bz2
	sh -x toolchain/patch-kernel.sh $(REAL_AUMIX_DIR) $(AUMIX_DIR)/patches \*.patch ; 
	touch $@

#
# configure the source, here we don't use configure, but in most cases
# we will have to
# see buildroot documentation how this is done
#
$(AUMIX_DIR)/.configured: $(AUMIX_DIR)/.unpacked
	( cd $(REAL_AUMIX_DIR) ; \
	  $(TARGET_CONFIGURE_OPTS) ./configure --prefix=/usr --disable-nls ) 
	touch  $@

# 
# build package
# packages expects some configuration parameters as parameters to make
# (see Makefile to find out, what the makefile expects, this differs
# from makefile to makefile
#
$(REAL_AUMIX_DIR)/src/$(AUMIX_BINARY): $(AUMIX_DIR)/.configured
	$(MAKE) -C $(REAL_AUMIX_DIR)
#
# selectively install one binary
# 
$(TARGET_DIR)/$(AUMIX_TARGET_BINARY): $(REAL_AUMIX_DIR)/src/$(AUMIX_BINARY)
	install -D -m 775 $(REAL_AUMIX_DIR)/src/$(AUMIX_BINARY) $(TARGET_DIR)/$(AUMIX_TARGET_BINARY)
	$(STRIP) $@

aumix: $(TARGET_DIR)/$(AUMIX_TARGET_BINARY)

aumix-source: $(DL_DIR)/$(AUMIX_SOURCE) $(DL_DIR)/$(AUMIX_PATCH)

aumix-clean:
	$(MAKE) DESTDIR=$(TARGET_DIR) CC=$(TARGET_CC) -C $(REAL_AUMIX_DIR) uninstall
	-$(MAKE) -C $(REAL_AUMIX_DIR) clean

aumix-dirclean:
	rm -rf $(AUMIX_DIR)

#############################################################
#
# Toplevel Makefile options
#
#############################################################
# ifeq ($(strip $(BR2_PACKAGE_AUMIX)),y)
TARGETS+=aumix
# endif
