#############################################################
#
# libid3tag
#
#############################################################
LIBID3TAG_VERSION:=0.15.1b
LIBID3TAG_SOURCE:=libid3tag-$(LIBID3TAG_VERSION).tar.gz

LIBID3TAG_SITE:=http://$(SF_DL_HOST)/sourceforge/mad/
LIBID3TAG_DIR:=$(BUILD_DIR)/libid3tag-$(LIBID3TAG_VERSION)

LIBID3TAG_LIBRARY:=libid3tag.a
LIBID3TAG_TARGET_LIBRARY:=usr/lib/libid3tag.a

#
# download source
#
$(DL_DIR)/$(LIBID3TAG_SOURCE):
	 $(WGET) -P $(DL_DIR) $(LIBID3TAG_SITE)/$(LIBID3TAG_SOURCE) 

#
# unpack source and potentially patch package; use bzcat for bz2 files
#
$(LIBID3TAG_DIR)/.unpacked: $(DL_DIR)/$(LIBID3TAG_SOURCE)
	zcat $(DL_DIR)/$(LIBID3TAG_SOURCE) | tar -C $(BUILD_DIR) $(TAR_OPTIONS) -
	toolchain/patch-kernel.sh $(LIBID3TAG_DIR) package/mpd \
	     libid3tag-\*.patch
	touch $@

#
# configure source, add additional options to configure as required
# call ./configure --help to find out about additional options
#
$(LIBID3TAG_DIR)/.configured: $(LIBID3TAG_DIR)/.unpacked
	( cd $(LIBID3TAG_DIR) ; $(TARGET_CONFIGURE_OPTS) ./configure --prefix=/usr --disable-nls )
	touch  $@

#
# build package
# 
$(LIBID3TAG_DIR)/$(LIBID3TAG_LIBRARY): $(LIBID3TAG_DIR)/.configured
	$(MAKE) -C $(LIBID3TAG_DIR) CC=$(TARGET_CC) 

#
# install package
#
$(TARGET_DIR)/$(LIBID3TAG_TARGET_LIBRARY): $(LIBID3TAG_DIR)/$(LIBID3TAG_LIBRARY)
	$(FAKEROOT) $(MAKE) -C $(LIBID3TAG_DIR) DESTDIR=$(TARGET_DIR) install

libid3tag: $(TARGET_DIR)/$(LIBID3TAG_TARGET_LIBRARY)

libid3tag-source: $(DL_DIR)/$(LIBID3TAG_SOURCE)

libid3tag-clean:
	$(MAKE) DESTDIR=$(TARGET_DIR) CC=$(TARGET_CC) -C $(LIBID3TAG_DIR) uninstall
	-$(MAKE) -C $(LIBID3TAG_DIR) clean

libid3tag-dirclean:
	rm -rf $(LIBID3TAG_DIR)

#############################################################
#
# Toplevel Makefile options
#
#############################################################
# ifeq ($(strip $(BR2_PACKAGE_LIBID3TAG)),y)
TARGETS+=libid3tag
# endif
